;------------------------------------------------------------------------------
;
; Title:			ds30 Loader for PIC18F
;
; File description:	user settings and configuration bits
;
; Copyright: 		Copyright � 09-11, Mikael Gustafsson
;
; Webpage: 			http://mrmackey.no-ip.org/elektronik/ds30loader/
;
; History:			3.0.0 first version of this file
;                                                                             
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
;    This file is part of ds30 Loader.
;
;    ds30 Loader is free software: you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation.
;
;    ds30 Loader is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with ds30 Loader. If not, see <http://www.gnu.org/licenses/>.
;------------------------------------------------------------------------------



;------------------------------------------------------------------------------
; Device
;------------------------------------------------------------------------------
		processor	18F2550							;xxx


;------------------------------------------------------------------------------
; Includes
;------------------------------------------------------------------------------
        #include "devices.inc"


;------------------------------------------------------------------------------
; User preferences
;------------------------------------------------------------------------------
		radix DEC
		
		#define		OSCF			48000000		;xxx oscillator frequency
		#define		BLINIT			2000			;xxx hello receive timeout [ms]
		#define		HELLOTRIES		2				;xxx number of non hello characters received before branching to the user application
		#define		BLTIME			2000			;xxx data receive timeout [ms]


;------------------------------------------------------------------------------
; UART settings
;------------------------------------------------------------------------------			
		#define		USE_UART1		1				;xxx uncomment to use uart1
		;#define	USE_UART2		1				;xxx uncomment to use uart2
		#define		BAUDRATE	 	115200			;xxx baudrate
        ;#define	USE_ABAUD		1				;xxx uncomment to use auto baud rate detection, READ ERRATA FIRST        
		;#define	USE_BRG16		1				;xxx uncomment to use 16-bit brg
		;#define	USE_TXENABLE	1				;xxx uncomment to use a tx enable pin		
		#ifdef USE_TXENABLE
			#define	TRISR_TXE		TRISC			;xxx tris register containing tx enable
			#define	LATR_TXE		LATC			;xxx port register containing tx enable
			#define	TRISB_TXE		TRISC6			;xxx tris bit for tx enable
			#define LATB_TXE		RC6				;xxx port bit for tx enable
		#endif


;------------------------------------------------------------------------------
; CAN settings, commercial version only www.ds30loader.com
;------------------------------------------------------------------------------		
		

;------------------------------------------------------------------------------
; Security, commercial version only www.ds30loader.com
;------------------------------------------------------------------------------'


;------------------------------------------------------------------------------
; Advanced settings
;------------------------------------------------------------------------------		
		#define		PROT_GOTO		1				;xxx protect goto at 0x00
		#define		PROT_BL 		1				;xxx protect bootloader
		
		ifdef IS_PIC18F
				#define		BLPLP		8			;bootloader placement, pages from end
				#define		BLSIZEP		8			;bootloader size [pages], used by bootloader protection	
		endif
		
		ifdef IS_PIC18FJ		
				#define		BLPLP		2			;bootloader placement, pages from end
				#define		BLSIZEP		1			;bootloader size [pages], used by bootloader protection	
		endif
		

;------------------------------------------------------------------------------
; Configuration bits, these macros can be found at the end of the inc-files located in 
; C:\Program Files\Microchip\MPASM Suite\
;
; These can also be set in MPLAB IDE instead, they are found in Configure->Configuration bits...
;------------------------------------------------------------------------------
		
		; xxx
		
		config	PLLDIV 	= 2				;PLL Prescaler Selection bits
		config	CPUDIV 	= OSC1_PLL2		;System Clock Postscaler Selection bits
		config	USBDIV 	= 2				;USB Clock Selection bit (used in Full-Speed USB mode only; UCFG:FSEN = 1)
		config	FOSC 	= HSPLL_HS		;Oscillator Selection bits
		config	FCMEN	= OFF			;Fail-Safe Clock Monitor Enable bit
		config	IESO	= OFF			;Internal/External Oscillator Switchover bit
		config	PWRT 	= OFF			;Power-up Timer Enable bit
		config	BOR		= OFF			;Brown-out Reset Enable bits
		config	BORV	= 0				;Brown-out Reset Voltage bits
		config	VREGEN	= OFF			;USB Voltage Regulator Enable bit
		config	WDT		= OFF			;Watchdog Timer Enable bit
		config	WDTPS	= 1				;Watchdog Timer Postscale Select bits
		config	CCP2MX	= OFF			;CCP2 MUX bit
		config	PBADEN	= OFF			;PORTB A/D Enable bit
		config	LPT1OSC	= OFF			;Low-Power Timer 1 Oscillator Enable bit
		config 	MCLRE	= ON			;MCLR Pin Enable bit
		config	STVREN	= ON			;Stack Full/Underflow Reset Enable bit
		config	LVP		= OFF			;Single-Supply ICSP Enable bit
		config	XINST	= OFF			;Extended Instruction Set Enable bit
		config	DEBUG	= OFF			;Background Debugger Enable bit
		config 	CP0		= OFF			;Code Protection bit
		config 	CP1		= OFF			;Code Protection bit
		config 	CP2		= OFF			;Code Protection bit
		config 	CP3		= OFF			;Code Protection bit
		config 	CPB		= OFF			;Boot Block Code Protection bi
		config 	CPD		= OFF			;Data EEPROM Code Protection bit
		config	WRT0	= OFF			;Write Protection bit
		config	WRT1	= OFF			;Write Protection bit
		config	WRT2	= OFF			;Write Protection bit
		config	WRT3	= OFF			;Write Protection bit
		config	WRTC	= OFF			;Configuration Register Write Protection bit
		config	WRTB	= OFF			;Boot Block Write Protection bit
		config	WRTD	= OFF			;Data EEPROM Write Protection bit
		config	EBTR0	= OFF			;Table Read Protection bit
		config	EBTR1	= OFF			;Table Read Protection bit
		config	EBTR2	= OFF			;Table Read Protection bit
		config	EBTR3	= OFF			;Table Read Protection bit
		config	EBTRB	= OFF			;Boot Block Table Read Protection bit


;------------------------------------------------------------------------------
; End of file
;------------------------------------------------------------------------------	
